<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*/

/** */
require_once 'entity.php';
require_once 'message.php';
require_once APPPATH.'libraries/attachment.php';

/**
* @package direct-as-a-service
* @subpackage models
*/
class Patient extends Entity {
	
	protected $_attachment_name;
	
//////////////////
// STATIC VARS
///////////////////	
	static $database_group = 'mail_db';
	static $table = 'patients';	
	protected static $_relationships = array( 'message' => array('type' => 'belongs_to'));
	
/////////////////////
// INSTANCE METHODS
/////////////////////
	
	function attachment_name(){
		if(!isset($this->_attachment_name)){
			$message = $this->message;
			if(Message::is_an_entity($message)){
				foreach($message->attachment_files as $name => $binary_string){							
					if($this->file_hash == sha1($name.$binary_string)){
						$this->_attachment_name = $name;
						break;
					}			
				}
			}
		}
		return $this->_attachment_name;
	}
		
	function name(){
		return implode_nonempty(' ', array($this->given_name, $this->family_name));
	}
	
	function values_for_api(){
		$values = $this->values();
		unset($values['id']); //not that useful for API, since we rewrite patient db entries frequently
		unset($values['message_id']); 
		$values['file_name'] = $this->attachment_name();
		return $values;
	}
	
///////////////////////
// STATIC METHODS
///////////////////////	
	
	public static function populate_for_message($message){
		if(!Message::is_an_entity($message)) return should_be('message entity', $message);
		
		//clear any old patients for this message
		Patient::db()->where(Message::foreign_key('patient'), $message->id)->delete(Patient::$table);		
		
		//populate with new patients for the message
		foreach($message->attachment_files as $name => $binary_string){
			$attachment = Attachment::create($name, $binary_string, array('message_id' => $message->id));
			if(is_a($attachment, 'Patient_document_attachment') && is_object($attachment->parser)){
				Patient::create( array(Message::foreign_key('patient') => $message->id,
									   'given_name' => implode_nonempty(' ', $attachment->parser->given_names),
									   'family_name' => $attachment->parser->family_name,
									   'title' => $attachment->parser->title,
									   'date_of_birth' => $attachment->parser->raw_value('date_of_birth'),
									   'organization' => $attachment->parser->organization,
									   'file_hash' => sha1($name.$binary_string),
								));				   
			}
		}	
	}
		
}
